Summary: Secure RPC package
Name: sec_rpc
Version: 1.54
Release: 1
URL: http://www.math.ualberta.ca/imaging/snfs/
Source0: %{name}-%{version}.tar.gz
License: GPL, BSD-like
BuildRoot: %{_tmppath}/%{name}-root
Requires: openssh
Group: System Environment/Daemons


%description
The sec_rpc package enables forwarding udp based rpc calls through ssh, and is
specifically intended for securing nfs.

%package client
Summary: Client-side sec_rpc package
Group: System Environment/Daemons
BuildPrereq: perl
Requires: openssh-clients, sec_rpc, perl >= 5.006

%description client

The sec_rpc package enables forwarding udp based rpc calls through ssh, and is 
specifically intended for securing nfs. This package includes anything 
necessary to mount securely nfs filesystems from a server.

NOTE: After installation, an /etc/fstab.snfs file is created from the
/etc/fstab file, with the nfs mount information updated to be compatible with
sec_rpc. You can use that file as a template for /etc/fstab changes or even
replace /etc/fstab with it.

You will also need to give the snfs user its private keys in order to be able
to contact the server. You can use the snfsuser script for this.

%package server
Summary: Server-side  sec_rpc package
Group: System Environment/Daemons
Requires: openssh-server, sec_rpc

%description server

The sec_rpc package enables forwarding udp based rpc calls through ssh, and is
specifically intended for securing nfs. This package includes anything 
necessary to respond to requests from clients willing to mount nfs filesystems
securely.

NOTE: After installation, you should modify your /etc/exports file in order to
allow local nfs mounts only, or you won't be able to benefit from the enhanced
security. You should also change /etc/hosts.allow to allow portmap access from
your local IP address only.

A userid snfs will be automatically created with ssh public keys, without
passphrases. To export these keys to your nfs clients you may use the
snfsuser script with the  --export option.

%prep
%setup -q

%build
%configure
make clean
make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall RPM_BUILD_ROOT=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%post client
id snfs >/dev/null 2>&1 || snfsuser --create-user
if [ "$1" = 1 ]; then
    chkconfig snfs reset
    snfsfstab
fi
chown snfs. /etc/snfs /var/log/snfs

%post server
if [ "$1" = 1 ]; then
    id snfs >/dev/null 2>&1 || snfsuser --create-keys
fi
chown snfs. /etc/snfs /var/log/rpc_pcl

%files
%defattr(-,root,root)
%{_bindir}/snfsuser
%dir %{_sysconfdir}/snfs

%doc README.NFS
%doc README
%doc README.RPC
%doc NFS/FAQ
%doc NFS/examples
%doc NFS/README.Solaris

%files client
%defattr(-,root,root)
%{_bindir}/rpc_psrv
%{_bindir}/snfsmount
%{_bindir}/snfsumount
%{_bindir}/smount
%{_bindir}/sumount
%{_bindir}/sumountall
%{_bindir}/smkdirall
%{_bindir}/snfshost
%{_bindir}/snfsfstab
%{_bindir}/snfspsrv
%{_bindir}/fake-agent
%config %{_sysconfdir}/snfs/TEMPLATE
%{_sysconfdir}/init.d/snfs
%dir %{_var}/run/snfs
%dir %{_var}/log/snfs
%{_libdir}/perl*/site_perl/*/SNFS.pm
%{_libdir}/perl*/site_perl/*/auto/SNFS/*
%{_mandir}/*/SNFS*
# Use this line for rpm builds under mandrake:
# %{_libdir}/perl*/man/*/SNFS*

%files server
%defattr(-,root,root)
%attr(4755,root,root) %{_bindir}/rpc_pcl
%config %{_sysconfdir}/rpc_pcl.conf
%{_var}/log/rpc_pcl

%changelog
* Mon Jun 17 2002 Dumas Patrice <dumas@centre-cired.fr>
- Initial build.
