/*
 * rpc_to_str.h
 *
 * Analyse an RPC message, convert several parts to an ASCII string.
 *
 * 18 Jan 1996, hot@informatik.tu-chemnitz.de
 */

#include "servconf.h"

#ifndef RPC_TO_STR
#define RPC_TO_STR

#define DUMP_SIZE 1000         /* maximum length of packet dumps for debug */
#define SEC_RPC_REPLY_ERROR -1 /* there was an error and a reply should be sent */
#define SEC_RPC_NO_REPLY -2    /* there was an error but no  reply should be sent */

struct call_body_32 {
	u_int cb_rpcvers;	/* must be equal to two */
	u_int cb_prog;
	u_int cb_vers;
	u_int cb_proc;
	struct opaque_auth cb_cred;
	struct opaque_auth cb_verf; /* protocol specific - provided by client */
};

struct rpc_msg_32 {
	u_int		rm_xid;
	enum msg_type		rm_direction;
	union {
		struct call_body_32 RM_cmb;
		struct reply_body RM_rmb;
	} ru;
};

/* convert a request to ASCII string */
char *rpc_request_to_str(u_char *request, int req_len, int show_message);

/* convert a reply to ASCII string */
char *rpc_reply_to_str(u_char *reply, int rep_len, int show_message);

/* check authentication and validity of a rpc request, and return a debug
 * dump of the packet in result_string if not NULL */
int check_rpc_request(u_char *request, int req_len, forward *forwarded_progs, u_int num_forwarded_progs, char *result_string, u_long *xid, int show_message);
#endif
