/*
 * map_xid.h
 *
 * Mapping RPC XIDs to a unique new one and vice versa.
 *
 * 2 Feb 1996, hot@informatik.tu-chemnitz.de
 */

#ifndef MAPXID_H
#define MAPXID_H

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <time.h>

/*
 * Structure of a map list entry
 */

typedef struct map_item
{
  struct sockaddr_in socket_addr;  /* client's address */
  u_int orig_XID;                 /* original XID, set by the client */
  u_int unique_XID;               /* the unique XID, set by the proxy */ 
  u_int ref_count;                 /* reference counter */ 
  time_t last_ref;                 /* time of last reference */
  struct map_item *next,           /* next element in the list */
                  *prev;           /* previous element in the list */
} map_item;

/*
 * number of entries in the hash tables
 *
 * should be an integer of the form 2^n
 */

#define HASH_ENTRIES (1 << 10)

/* initialize the mapping mechanism */
void map_init(int max_rc);

/* search for an existing specific mapping */
map_item *find_XID_mapping(u_int xid, struct sockaddr_in *socket_addr);

/* map an original XID to a unique one */
int map_XID(u_char *buffer, struct sockaddr_in *socket_addr);

/* map the unique XID back to the original one */
int demap_XID(u_char *buffer, struct sockaddr_in *socket_addr);

/* reap stale mapping entries */
int grim_reap(int reap_interval);

#endif
