/*
 * log-server.h
 *
 * Server-side versions of debug(), log(), etc.  
 *
 * 16 Jan 1996, hot@informatik.tu-chemnitz.de
 */

#ifndef LOGSERVER_H
#define LOGSERVER_H

/* Initialize the log. */
void log_init(char *av0, int debug, int on_syslog, int quiet, 
              int facility);

/* Log this message (information that usually should go to the log). */
void log(const char *fmt, ...);

/* Debugging messages that should not be logged during normal operation. */
void debug(const char *fmt, ...);

/* Error messages that should be logged. */
void error(const char *fmt, ...);

/* Registers a cleanup function to be called by fatal() before exiting. */
void fatal_add_cleanup(void (*proc)(void *), void *context);

/* Removes a cleanup frunction to be called at fatal(). */
void fatal_remove_cleanup(void (*proc)(void *context), void *context);

/* Fatal messages.  This function never returns. */
void fatal(const char *fmt, ...);

#endif
