/* gdg.h -- Intel GDG DRM template customization -*- linux-c -*-
 */
/**************************************************************************
 * 
 * Copyright 2003 Tungsten Graphics, Inc., Cedar Park, Texas.
 * All Rights Reserved.
 * 
 **************************************************************************/

#ifndef __GDG_H__
#define __GDG_H__

/* This remains constant for all DRM template files.
 */
#define DRM(x) gdg_##x

/* General customization:
 */
#define __HAVE_AGP		1
#define __MUST_HAVE_AGP		1
#define __HAVE_MTRR		1
#define __HAVE_CTX_BITMAP	1

#define DRIVER_AUTHOR		"Tungsten Graphics, Inc."

#define DRIVER_NAME		"gdg"
#define DRIVER_DESC		"Intel Graphics"
#define DRIVER_DATE		"20040331"

/* Interface history:
 *
 * 1.1: Original.
 */
#define DRIVER_MAJOR		1
#define DRIVER_MINOR		1
#define DRIVER_PATCHLEVEL	0


#define DRIVER_IOCTLS							    \
	[DRM_IOCTL_NR(DRM_IOCTL_GDG_INIT)]   = { gdg_dma_init,    1, 1 }, \
	[DRM_IOCTL_NR(DRM_IOCTL_GDG_FLUSH)]  = { gdg_flush_ioctl, 1, 0 }, \
	[DRM_IOCTL_NR(DRM_IOCTL_GDG_FLIP)]   = { gdg_flip_bufs,   1, 0 }, \
	[DRM_IOCTL_NR(DRM_IOCTL_GDG_BATCHBUFFER)] = { gdg_batchbuffer, 1, 0 }, \
	[DRM_IOCTL_NR(DRM_IOCTL_GDG_IRQ_EMIT)] = { gdg_irq_emit,  1, 0 }, \
	[DRM_IOCTL_NR(DRM_IOCTL_GDG_IRQ_WAIT)] = { gdg_irq_wait,  1, 0 }, \
	[DRM_IOCTL_NR(DRM_IOCTL_GDG_GETPARAM)] = { gdg_getparam,  1, 0 }, \
	[DRM_IOCTL_NR(DRM_IOCTL_GDG_SETPARAM)] = { gdg_setparam,  1, 0 }, \
        [DRM_IOCTL_NR(DRM_IOCTL_GDG_ALLOC)]   = { gdg_mem_alloc,  1, 0 }, \
        [DRM_IOCTL_NR(DRM_IOCTL_GDG_FREE)]    = { gdg_mem_free,    1, 0 }, \
        [DRM_IOCTL_NR(DRM_IOCTL_GDG_INIT_HEAP)] = { gdg_mem_init_heap, 1, 1 }

#define DRIVER_PCI_IDS					\
	{0x8086, 0x3577, 0, "Intel i830M GMCH"},	\
	{0x8086, 0x2562, 0, "Intel i845G GMCH"},	\
	{0x8086, 0x3582, 0, "Intel i852GM/i855GM GMCH"},\
	{0x8086, 0x2572, 0, "Intel i865G"}, 		\
	{0x8086, 0x2582, 0, "Intel i915G"},		\
	{0, 0, 0, NULL}


#define __HAVE_COUNTERS         4
#define __HAVE_COUNTER6         _DRM_STAT_IRQ
#define __HAVE_COUNTER7         _DRM_STAT_PRIMARY
#define __HAVE_COUNTER8         _DRM_STAT_SECONDARY
#define __HAVE_COUNTER9         _DRM_STAT_DMA

/* Driver customization:
 */

#define DRIVER_PRETAKEDOWN() do {					\
	if ( dev->dev_private ) {					\
		drm_gdg_private_t *dev_priv = dev->dev_private;	\
	        gdg_mem_takedown( &(dev_priv->agp_heap) );             \
 	}								\
	gdg_cleanup( dev );					\
} while (0)


/* When a client dies:
 *    - Free any alloced agp memory.
 */
#define DRIVER_PRERELEASE() 						\
do {									\
	if ( dev->dev_private ) {					\
		drm_gdg_private_t *dev_priv = dev->dev_private;	\
                gdg_mem_release( dev, filp, dev_priv->agp_heap );	\
	}								\
} while (0)




/* We use our own dma mechanisms, not the drm template code.  However,
 * the shared IRQ code is useful to us:
 */
#define __HAVE_DMA		0
#define __HAVE_IRQ		1
#define __HAVE_SHARED_IRQ	1

#endif
