# cncterm
                CNCTERM - Text interface to LinuxCNC

##############
Introduction
##############

Cncterm is a curses-based interface to linuxcnc.  It is designed to be the user
interface for machines with less-capable processors or no direct video output,
such as running on a BeagleBone Green which does not have an HDMI or VGA
interface.

As a curses program, the interface can run happily over a serial line,
which could also be useful for remote control of a machine tool.

Current testing shows that running code on a BeagleBone Green with
cncterm takes less than 30% of the CPU for everything, including loading
code off a networked server.

The code should work with up to 5 motion axes, spindle control, and
flood and mist coolant options. The code has provision for a MPG wheel,
and hardware cycle start and feed hold buttons. While not tested with a
tool changer, the code should work with manual and automatic tool
changers correctly configured in the HAL layer.

Cncterm has been developed on a machinekit installation on a BeagleBone
Green, but should work on any linuxcnc installation.


##############
Keyboard Interface
##############

Cncterm uses a standard alphanumeric keyboard for most interface tasks.
In addition to the alphanumeric keys, the interface needs the escape,
backspace, and F1 keys. This limited set of required keys allows the use
of serial terminals, including such ancient options as a VT52, for the
full interface. No mouse or touch screen is supported. The interface
uses the Python curses libraries, so any terminal supported by curses
should work without code change. Testing has been done with xterm and
vt220 terminals.

Keyboard commands
-----------------
Escape          Abort
Backspace       Abort
Tab             Next tab (right, loops)
Return          Clear messages, redraw screen
Up, Down        Jog Y+, Y-
Left, Right     Jog X-, X+
PgUp, PgDn      Default Tab: Jog Z+, Z-; Code, Tool Tab: previous, next page
Home, End       Home selected, all axes
F1, ^O          Override limit switches
A               Select A axis (4th)
B               Select B axis (5th)
C               Automatic mode - for running programs
D               MDI mode - for executing input commands
E               Toggle E-Stop
F               Flood coolant, toggle on/off
G               Redraw screen
H               Toggle Optional Stop (M1)
I               Mist coolant, toggle on/off
J               Move one tab left, wraps around
K               Move one tab right, wraps around
L               Reload tool table
M               Manual mode - for jogging & manual cutting
N               Set coordinate offsets, via dialog
O               Open program file, via file chooser dialog
P               Pause executing program
Q               QUIT - No Confirmation!
R               Run currently-loaded program
S               Reset interpreter
T               Toggle machine on/off (enable)
U               Cycle Jog Steps, wraps
V               Page Down - see PgDn
W               Page Up - see PgUp
X               Select X axis (1st)
Y               Select Y axis (2nd)
Z               Select Z axis (3rd)
\               Toggle Block Delete
|               Redraw screen
' or "          Enter MDI command in dialog
;               Home current axis
:               Home all axes
0,1-9           Feed rate override 100%, 10-90%
%,^,&,*,(,)	Spindle speed override 50, 60, 70, 80, 90, 100%
!,@,#		Spindle speed override 110, 120, 130%
$               Radius, Diameter display toggle (lathe mode only)
= or +          Spindle RPM increase
-               Spindle RPM decrease
[ or {          Jog 1 step negative
] or }          Jog 1 step negative, positive
, or <          Spindle Reverse
. or >          Spindle Forward
/ or ?          Spindle Off


##############
INI File Entries
##############
No specific cncterm ini file settings at this time.  However, make sure that:
*) all joint entries have a TYPE of LINEAR or ANGULAR
*) TRAJ - COORDINATES has only the letters of the axes to use!
*) there is a JOINT and AXIS entry for each letter in the COORDINATES line


##############
HAL Pins
##############
These pins setup after starting the cncterm interface to create the cncterm.* HAL pins.

#### Start of HAL file
  # connect various pins for cncterm interface
  net cncterm-wheel cncterm.jog.wheel.increment => joint.0.jog-scale joint.1.jog-scale joint.2.jog-scale joint.3.jog-scale
  net cncterm-wheel-x cncterm.jog.wheel.x joint.0.jog-enable
  net cncterm-wheel-y cncterm.jog.wheel.y joint.1.jog-enable
  net cncterm-wheel-z cncterm.jog.wheel.z joint.2.jog-enable
  net cncterm-wheel-a cncterm.jog.wheel.a joint.3.jog-enable

  net cncterm-wheel cncterm.jog.wheel.increment => axis.x.jog-scale axis.y.jog-scale axis.z.jog-scale axis.a.jog-scale
  net cncterm-wheel-x cncterm.jog.wheel.x axis.x.jog-enable
  net cncterm-wheel-y cncterm.jog.wheel.y axis.y.jog-enable
  net cncterm-wheel-z cncterm.jog.wheel.z axis.z.jog-enable
  net cncterm-wheel-a cncterm.jog.wheel.a axis.a.jog-enable

  net encoder-counts cncterm.wheel-counts

  # these pins inverted in kneemill.hal
  net abort-raw debounce.0.5.in <= bb_gpio.p8.in-28
  net cncterm-abort cncterm.abort <= debounce.0.5.out
  net start-raw debounce.0.6.in <= bb_gpio.p8.in-30
  net cncterm-start cncterm.cycle-start <= debounce.0.6.out
  net block-raw debounce.0.7.in <= bb_gpio.p8.in-31
  net cncterm-block cncterm.single-block <= debounce.0.7.out

  net cncterm-active cncterm.jog.active => bb_gpio.p8.out-32
  net cncterm-status cncterm.status-light => bb_gpio.p8.out-33
#### EOF



##############
TODO
##############
Backplot screen - perhaps via gnuplot and DEC sixel graphics?

