/*
 * printSEGYposition.cpp - print positions from SEGY file
 *
 * This file is part of Automaton.
 *
 * Copyright (C) 2002, 2003
 * Paul Gettings, Dep't of Geology & Geophysics
 * University of Utah
 *
 * This file is released under the terms of the software
 * license in the file "LICENSE" in the root directory of
 * this package.  If this file is missing or corrupt, please
 * contact the author to receive a new copy.
 *
 * Automaton is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  Use at your
 * own risk; your mileage may vary.
 *
 * Suggestions, improvements, and bug reports welcome at
 * <gettings@mines.utah.edu>
 */
#include <stdio.h>
#include <stdlib.h>

#include "segy.h"
#include "autopick.h"

int main(int argc, char *argv[])
{
  long i;
  FILE *sfp;
  long shot, chan;
  float x, y;
  unsigned char buf[3600];

  bool swapBytes = true; // SEGY is big-endian, and Intel is little-

  if(argc < 2) {
    fprintf(stderr, "usage: %s segy_file [segy_file ...]\n", argv[0]);
    fprintf(stderr, "SEGY files should NOT have reel headers!\n");
    exit(1);
    }

  for(i=1; i<argc; i++) {
    if((sfp = fopen(argv[i], "r+b")) == NULL) {
      fprintf(stderr, "cannot open '%s' for read/write.\n", argv[i]);
      exit(1);
      }
    // assume there is no reel header
    unsigned long pos;
    short scale;
    printf("#Shot_ Channl _____X____ _____Y____\n");
    while(!feof(sfp)) {
      pos = ftell(sfp);
      // read bits of the trace header to get shot #, chan #
      fseek(sfp, pos+8L, SEEK_SET);
      fread(buf, 4, 1, sfp);
      if(feof(sfp)) continue;
      shot = headerLong(buf, swapBytes);
      fread(buf, 4, 1, sfp);
      chan = headerLong(buf, swapBytes);
      fseek(sfp, pos+70, SEEK_SET);
      fread(buf, 2, 1, sfp);
      scale = headerShort(buf, swapBytes);

      fseek(sfp, pos+80, SEEK_SET);
      fread(buf, 4, 1, sfp);
      x = headerPosition(buf, swapBytes, scale);
      fread(buf, 4, 1, sfp);
      y = headerPosition(buf, swapBytes, scale);
      printf("%6d %6d %10.3f %10.3f\n", shot, chan, x ,y);
      // move to next header
      fseek(sfp, pos+114, SEEK_SET);
      fread(buf, 2, 1, sfp);
      unsigned short nsamp;
      nsamp = (unsigned short) headerShort(buf, swapBytes);
      fseek(sfp, pos+240+(nsamp*4), SEEK_SET); // skip trace data
      }
    fclose(sfp);
    }
  exit(0);
}

